/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipEncap_diag.h 51162 2015-01-29 10:21:28Z kai $:

Description:
  Diagnosis Codes of the EthernetIP Encapsulation task

**************************************************************************************/

#ifndef __EIP_ENCAP_DIAG_H
#define __EIP_ENCAP_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet/IP Encapsulation
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_LIDENTITY_PACKET
//
// MessageText:
//
//  No free packet available to indicate the received List Identity information.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_LIDENTITY_PACKET ((TLR_RESULT)0xC01E0001L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_ENCAP_CMD_PACKET
//
// MessageText:
//
//  No free packet available to send a request to the ethernet interface.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_ENCAP_CMD_PACKET ((TLR_RESULT)0xC01E0002L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_REGISTER_PACKET
//
// MessageText:
//
//  No free packet available to send a register session request to the ethernet interface.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_REGISTER_PACKET ((TLR_RESULT)0xC01E0003L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_CMD_TCP_SEND_PACKET_FAIL
//
// MessageText:
//
//  Send packet to the ethenet interface failed.
//
#define TLR_DIAG_E_EIP_ENCAP_CMD_TCP_SEND_PACKET_FAIL ((TLR_RESULT)0xC01E0004L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_LSERVICE_PACKET
//
// MessageText:
//
//  No free packet available to indicate the received List Service information.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_LSERVICE_PACKET ((TLR_RESULT)0xC01E0005L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_LINTERFACE_PACKET
//
// MessageText:
//
//  No free packet available to indicate the received List Interface information.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_LINTERFACE_PACKET ((TLR_RESULT)0xC01E0006L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_MULTICAST_JOIN_PACKET
//
// MessageText:
//
//  No free packet available to join the multicast group.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_MULTICAST_JOIN_PACKET ((TLR_RESULT)0xC01E0007L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_MULTICAST_DROP_PACKET
//
// MessageText:
//
//  No free packet available to drop the multicast group.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_MULTICAST_DROP_PACKET ((TLR_RESULT)0xC01E0008L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_CONNECTING_INVALID_PACKET_ID
//
// MessageText:
//
//  By establishing a new connection an invalid packet ID was received.
//
#define TLR_DIAG_E_EIP_ENCAP_CONNECTING_INVALID_PACKET_ID ((TLR_RESULT)0xC01E0009L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_WAIT_CONN_INVALID_PACKET_ID
//
// MessageText:
//
//  By waiting for a connection an invalid packet ID was received.
//
#define TLR_DIAG_E_EIP_ENCAP_WAIT_CONN_INVALID_PACKET_ID ((TLR_RESULT)0xC01E000AL)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_CEP_OVERRUN
//
// MessageText:
//
//  No free connection endpoints are available.
//
#define TLR_DIAG_E_EIP_ENCAP_CEP_OVERRUN ((TLR_RESULT)0xC01E000BL)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_CONNECTION_INACTIVE
//
// MessageText:
//
//  Receive data from a inactiv or unknown connection.
//
#define TLR_DIAG_E_EIP_ENCAP_CONNECTION_INACTIVE ((TLR_RESULT)0xC01E000CL)

//
// MessageId: TLR_DIAG_W_EIP_ENCAP_CONNECTION_CLOSED
//
// MessageText:
//
//  Connection is closed.
//
#define TLR_DIAG_W_EIP_ENCAP_CONNECTION_CLOSED ((TLR_RESULT)0xC01E000DL)

//
// MessageId: TLR_DIAG_W_EIP_ENCAP_CONNECTION_RESET
//
// MessageText:
//
//  Connection is reseted.
//
#define TLR_DIAG_W_EIP_ENCAP_CONNECTION_RESET ((TLR_RESULT)0xC01E000EL)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_RECEIVED_INVALID_DATA
//
// MessageText:
//
//  Receive invalid data, Connection is closed.
//
#define TLR_DIAG_E_EIP_ENCAP_RECEIVED_INVALID_DATA ((TLR_RESULT)0xC01E000FL)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_UNKNOWN_CONNECTION_TYP
//
// MessageText:
//
//  Receive data from a unknown connection typ.
//
#define TLR_DIAG_E_EIP_ENCAP_UNKNOWN_CONNECTION_TYP ((TLR_RESULT)0xC01E0010L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_CEP_STATE_ERROR
//
// MessageText:
//
//  Command is not allowed at the actual connection endpoint state.
//
#define TLR_DIAG_E_EIP_ENCAP_CEP_STATE_ERROR ((TLR_RESULT)0xC01E0011L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_INDICATION_PACKET
//
// MessageText:
//
//  No free packet available to send a indication of the received data.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_INDICATION_PACKET ((TLR_RESULT)0xC01E0012L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_REVEIVER_OUT_OF_MEMORY
//
// MessageText:
//
//  No memory for a receive buffer is available, data could not received.
//
#define TLR_DIAG_E_EIP_ENCAP_REVEIVER_OUT_OF_MEMORY ((TLR_RESULT)0xC01E0013L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_ABORT_IND_PACKET
//
// MessageText:
//
//  No free packet available to send a abort transport indication.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_ABORT_IND_PACKET ((TLR_RESULT)0xC01E0014L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_START_CONNECTION_FAIL
//
// MessageText:
//
//  Starting the connection failed. Connection enpoint is invalid.
//
#define TLR_DIAG_E_EIP_ENCAP_START_CONNECTION_FAIL ((TLR_RESULT)0xC01E0015L)

//
// MessageId: TLR_DIAG_E_EIP_ENCAP_NO_GET_TCP_CONFIG_PACKET
//
// MessageText:
//
//  No free packet for requesting the actual configuration from the TCP task.
//
#define TLR_DIAG_E_EIP_ENCAP_NO_GET_TCP_CONFIG_PACKET ((TLR_RESULT)0xC01E0016L)




#endif  //__EIP_ENCAP_DIAG_H

